//backtop
var addLoadEvent = function(func) {
	var oldonload = window.onload;
	if (typeof oldonload != "function") {
		window.onload = func;
	} else {
		window.onload = function() {
			if (oldonload) {
				oldonload();
			}
			func();
		}
	}
}
var Tween = {
	Quad: {
		easeOut: function(t, b, c, d) {
			return - c * (t /= d) * (t - 2) + b;
		},
		easeInOut: function(t, b, c, d) {
			if ((t /= d / 2) < 1) return c / 2 * t * t + b;
			return - c / 2 * ((--t) * (t - 2) - 1) + b;
		}
	}
}
var scrollBar = function() {
	var that = this;
	if (!document.getElementById("scrollBar")) {
		var ele = document.createElement("div");
		ele.id = "scrollBar";
		ele.innerHTML = '<a hideFocus="true" href="javascript:void(0)">backtop</a>';
		document.body.appendChild(ele);
	} else {
		var ele = document.getElementById("scrollBar");
	}
	var barTxt = "ص";
	var distance = 100;
	var dd = document.documentElement;
	var db = document.body;
	var scrollTop;
	this.setStyle = function() {
		scrollTop = db.scrollTop || dd.scrollTop;
		var sw = dd.scrollWidth;
		var pos = 'right:50%;margin-right:-550px;';
		var fullscreen = document.getElementById('fullscreenStyle');
		if ((fullscreen && !fullscreen.disabled) || sw < 1020) {
			pos = 'right:5px;';
		}
		var ctxt = scrollTop >= distance ? '': 'display:none';
		ele.style.cssText = 'position:fixed;' + pos + 'bottom:80px;' + ctxt;
	}
	this.update = function() {
		scrollTop = db.scrollTop || dd.scrollTop;
		ele.style.display = (scrollTop >= distance) ? "block": "none";
		if (!window.XMLHttpRequest) {
			var h = ele.offsetHeight;
			var ch = document.documentElement.clientHeight;
			ele.style.position = "absolute";
			ele.style.top = ch + scrollTop - h - 80 + "px";
		}
	}
	that.b = 0;
	that.c = 0;
	var d = 20,
	t = 0;
	this.run = function() {
		if (dd.scrollTop) {
			dd.scrollTop = Math.ceil(Tween.Quad.easeOut(t, that.b, that.c, d));
		} else {
			db.scrollTop = Math.ceil(Tween.Quad.easeOut(t, that.b, that.c, d));
		}
		if (t < d) {
			t++;
			setTimeout(that.run, 10);
		} else {
			t = 0;
		}
	}
	ele.onclick = function() {
		that.b = scrollTop;
		that.c = -scrollTop;
		that.run();
		return false;
	}
	this.init = function() {
		this.setStyle();
		window.onscroll = function() {
			that.update();
		}
		window.onresize = function() {
			that.setStyle();
			that.update();
		}
	}
}
var goTop;
addLoadEvent(function() {
	goTop = new scrollBar();
	goTop.init();
})